
module ov7670_vga_fb(CLOCK_50, HREF,VS, SDA, SCLK, clk_25, v_clk, incoming_data, pclk,R,G,B,VGA_VS,VGA_HS, VGA_BLANK_N, LEDR,reset, write, writedata, chipselect, address);
	input CLOCK_50;
	output [9:0] LEDR; 
	assign LEDR[9:0] = 10'b0;

	input	   	reset;
	input [7:0]  	writedata;
	input 	   	write;
	input 		chipselect;
	input [7:0] 	address;

	output reg [7:0] R;
	output reg [7:0] G;
	output reg [7:0] B;				//VGA
	output reg VGA_HS,VGA_VS;
	output wire VGA_BLANK_N;
	output wire v_clk;
	
	inout SDA;
	output SCLK;
	input VS,HREF;
	input pclk;						//OV7670
	input [7:0] incoming_data;
	output wire clk_25;
	reg [7:0] red, green , blue;
	wire [15:0] tx;
	wire [3:0] sccbState;
	
	assign v_clk = clk_25;
	

	 // framebuffer (FB)
    localparam FB_WIDTH  = 640;
    localparam FB_HEIGHT = 480;
    localparam FB_PIXELS = FB_WIDTH * FB_HEIGHT;
    localparam FB_ADDRW  = $clog2(FB_PIXELS);
    localparam FB_DATAW  = 8;  // color bits
	 localparam CORDW = 16;
    
    reg fb_we;	
    reg [FB_ADDRW-1:0] fb_addr_write, fb_addr_read;
    reg [FB_DATAW-1:0] fb_colr_write;
    reg [FB_DATAW-1:0] fb_colr_read;


   wire clk_100, clk_50, clk_12, clk_130, clk_150;

	clk_div clkdiv0 (
			.refclk(CLOCK_50),
			.rst(0),
			.outclk_0(clk_100),
			.outclk_1(clk_50),
			.outclk_2(clk_25),
			.outclk_3(clk_12),
			.outclk_4(clk_130),
			.outclk_5(clk_150)
		);

    bram_sdp #(
        .WIDTH(FB_DATAW),
        .DEPTH(FB_PIXELS)
    ) bram_inst (
        .clk_write(pclk),
        .clk_read(v_clk),
        .we(fb_we),
        .addr_write(fb_addr_write),
        .addr_read(fb_addr_read),
        .data_in(fb_colr_write),
        .data_out(fb_colr_read)
    );
	 
    reg [1:0] state = 0;
	 reg pixel_valid = 0;
	 
    always @(posedge pclk) begin
        case (state)
				0:
						if (VS & conf_done)
							state <= 1;
				1:
						if (~VS) begin
							fb_we <= 1;
							fb_addr_write <= 0;
							fb_colr_write <= incoming_data;
							state <= 2;
						end
				2:
						if (HREF) begin
							pixel_valid <= ~pixel_valid;
							if (pixel_valid) begin
									fb_addr_write <= fb_addr_write + 1;
									fb_colr_write <= incoming_data;
							end 
						end
						else if (VS)
							state <= 1;
												
        endcase
    end

    wire paint;  // which area of the framebuffer should we paint?
    assign paint = (sy >= 0 && sy < (FB_HEIGHT) && sx >= 0 && sx < (FB_WIDTH));
	 
    always @(posedge v_clk) begin
        if (frame) begin  // reset address at start of frame
            fb_addr_read <= 7;
				filter_rst <= 1;
			
        end else if (paint) begin  // increment address in painting area
            fb_addr_read <= fb_addr_read + 1;
	    filter_rst <=0;
        end
    end

    // reading from BRAM takes one cycle: delay display signals to match
    reg paint_p1, hsync_p1, vsync_p1;
    always @(posedge v_clk) begin
        paint_p1 <= paint;
        hsync_p1 <= hsync;
        vsync_p1 <= vsync;
    end

	 wire [7:0] filtered_pxl;
	 reg filter_mode ;
	 reg filter_rst;
	 
	always@(posedge pclk)begin
		
		   case(address)
				8'h00: filter_mode <= writedata;
				8'h01: filter_mode <= writedata;
		  default: filter_mode <= 8'b00;
			
		endcase 
		
	end

	 sobel filter
	 (	.clock(v_clk), 
		.reset(filter_rst),
		.inputPixel(fb_colr_read),
		.outputPixel(filtered_pxl)
		);
	 
	 // VGA output
	 	 
	 wire signed [CORDW-1:0] sx, sy;
	 wire vsync, hsync, de, line;
	 //frame sets fb_addr_read to 0
    wire frame;
	 reg vga_rst = 0;
	 
	 display_480p #(.CORDW(CORDW)) display_inst (
        .clk_pix(v_clk),
        .rst(vga_rst),
        .hsync(hsync),
        .vsync(vsync),
        .de(de),
        .frame(frame),
        .line(line),
	.sx(sx),
        .sy(sy)
    );
	 

    always @(posedge v_clk) begin
        VGA_HS <= hsync_p1;
        VGA_VS <= vsync_p1;
		  if(paint_p1)
			  begin
			  
				  R <= red;
				  G <= green;
				  B <= blue;
			  
			  end
    end
	 
	 always @(filter_mode) begin
		case(filter_mode)
			  1'b0: begin
				  red <= filtered_pxl;
				  green <= filtered_pxl;
				  blue <= filtered_pxl;
			  end
			  1'b1: begin
				  red <= fb_colr_read;
				  green <= fb_colr_read;
				  blue <= fb_colr_read;
			  end
	   endcase
	 end

	assign VGA_BLANK_N = de;
	
	
	reg [2:0]	strt = 3'd0;	
	wire conf_done;
	
	always @( posedge clk_25)
		if ( &strt )
			strt	<= strt;
		else
			strt	<= strt + 1'h1;	
	
	wire [7:0] SCCB_addr;
	wire [7:0] SCCB_data;
			
	camera_configure #(.CLK_FREQ (25000000)) camera_configure_0
	(
    .clk			( clk_25				),	
    .start 		(( strt == 3'h6 	)),
    .sioc 		( SCLK				),
    .siod 		( SDA					),
    .done 		( conf_done			),
	 .SCCB_addr (SCCB_addr			),
	 .SCCB_data (SCCB_data			)
	 );

endmodule
